<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 24.10.17.
 * Time: 16.23
 */

namespace Intellex\Generator\Text\HTML;

class HTMLh2Section extends HTMLh3Section {

	/** @var int $min Minimum number of paragraphs on start of h3 section. */
	private $min;

	/** @var int Maximum number of paragraphs on start of h3 section. */
	private $max;

	/** @var int $numOfParAfterH2 Number of paragraphs after <h2> title. */
	private $numOfParAfterH2;

	/** @var string $imgAPI API Key for pixabay. */
	private $imgAPI;

	/**
	 * HTMLh2Section constructor.
	 *
	 * @param string $imgAPI          API Key for pixabay.
	 * @param int    $min             Minimum number of h3 sections given to article.
	 * @param int    $max             Minimum number of h3 sections given to article.
	 * @param int    $numOfParAfterH2 Number of paragraphs after <h2> title.
	 */
	public function __construct($imgAPI = null, $min = 2, $max = 4, $numOfParAfterH2 = 1) {
		parent::__construct();
		$this->min = $min;
		$this->max = $max;
		$this->numOfParAfterH2 = $numOfParAfterH2;
		$this->imgAPI = $imgAPI;

	}

	/**
	 * Generates an H2 section.
	 *
	 * @return string
	 */
	public function generateValue() {
		return $this->generateH2Section($this->imgAPI);
	}

	/**
	 *  Generates an H2 section.
	 *
	 * @param string $imgAPI API Key for pixabay.
	 *
	 * @return string
	 */
	public function generateH2Section($imgAPI = null) {
		if ($this->imgAPI !== null) {
			$imgAPI = $this->imgAPI;
		}
		return implode("\n\n", [
			parent::tag('h2', parent::generateSentence(5, 7, null, false, null)),
			parent::generateParagraphs($imgAPI, $this->numOfParAfterH2, $this->numOfParAfterH2),
			parent::generateH3Sections($imgAPI, $this->min, $this->max)
		]);

	}

	/**
	 * Generate a random number of H3Sections.
	 *
	 * @param string $imgAPI API Key for pixabay.
	 * @param int    $min    Minimum number of H3Sections.
	 * @param int    $max    Minimum number of H3Sections.
	 *
	 * @return string The joined paragraphs.
	 */
	public function generateH2Sections($imgAPI = null, $min = 3, $max = 5) {

		$len = rand($min, $max);

		$paragraphs = [ ];
		for ($i = 0; $i < $len; $i++) {
			$paragraphs[] = $this->generateH2Section($imgAPI);
		}

		return implode("\n\n", $paragraphs);
	}
}