<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 24.10.17.
 * Time: 16.02
 */

namespace Intellex\Generator\Text\HTML;

class HTMLh3Section extends HTMLParagraphGenerator {

	/** @var int $min Minimum number of paragraphs on start of h3 section. */
	private $min;

	/** @var int Maximum number of paragraphs on start of h3 section. */
	private $max;

	/** @var string $imgAPI API Key for pixabay. */
	private $imgAPI;

	public function __construct($imgAPI = null, $min = 2, $max = 4) {
		parent::__construct();
		$this->min = $min;
		$this->max = $max;
		$this->imgAPI = $imgAPI;

	}

	/**
	 * Generates an H3 section.
	 *
	 * @return string
	 */
	public function generateValue() {
		return $this->generateH3Section($this->imgAPI);
	}

	/**
	 *  Generates an H3 section.
	 *
	 * @param string $imgAPI API Key for pixabay.
	 *
	 * @return string
	 */
	public function generateH3Section($imgAPI = null) {
		if ($this->imgAPI !== null) {
			$imgAPI = $this->imgAPI;
		}

		return implode("\n\n", [
			parent::tag('h3', parent::generateSentence(5, 7, null, false, null)),
			parent::generateParagraphs($imgAPI, $this->min, $this->max)
		]);
	}

	/**
	 * Generate a random number of H3Sections.
	 *
	 * @param string $imgAPI API Key for pixabay.
	 * @param int    $min    Minimum number of H3Sections.
	 * @param int    $max    Minimum number of H3Sections.
	 *
	 * @return string The joined paragraphs.
	 */
	public function generateH3Sections($imgAPI = null, $min = 3, $max = 5) {

		$len = rand($min, $max);

		$paragraphs = [ ];
		for ($i = 0; $i < $len; $i++) {
			$paragraphs[] = $this->generateH3Section($imgAPI);
		}

		return implode("\n\n", $paragraphs);
	}
}