<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 23.10.17.
 * Time: 17.06
 */

namespace Intellex\Generator\Text;

use Intellex\Generator\Core\ItemGenerator;
/**
 * Generates a single word.
 *
 * @package Intellex\AutoPopulate\Generator
 */
class WordGenerator extends ItemGenerator {

	/** @var string[] The list of default words, where all have same chance of being picked out. */
	private $defaultWords = [ 'lorem', 'ipsum', 'dolor', 'sit', 'amet', 'consectetur', 'adipiscing', 'elit', 'sed',
		'do', 'eiusmod', 'tempor', 'incididunt', 'ut', 'labore', 'et', 'dolore', 'magna', 'aliqua', 'ut', 'enim', 'ad',
		'minim', 'veniam', 'quis', 'nostrud', 'exercitation', 'ullamco', 'laboris', 'nisi', 'ut', 'aliquip', 'ex', 'ea',
		'commodo', 'consequat', 'duis', 'aute', 'irure', 'dolor', 'in', 'reprehenderit', 'in', 'voluptate', 'velit',
		'esse', 'cillum', 'dolore', 'eu', 'fugiat', 'nulla', 'pariatur', 'excepteur', 'sint', 'occaecat', 'cupidatat',
		'non', 'proident', 'sunt', 'in', 'culpa', 'qui', 'officia', 'deserunt', 'mollit', 'anim', 'id', 'est', 'laborum' ];

	/**
	 * Constructor for WordGenerator.
	 * WordGenerator constructor.
	 *
	 * @param string[] $words The list of words, where all have same chance of being picked out.
	 */
	public function __construct($words = null) {
		parent::__construct($words ? $words : $this->defaultWords);
	}

}