<?php namespace Intellex\MailChimp\Api;

use Intellex\MailChimp\Resource\ResourceCampaign;
use Intellex\MailChimp\Resource\ResourceReport;

/**
 * Class ReportApi
 *  Handles all campaign reports API operations.
 *
 * @package Intellex\MailChimp\Api
 */
class ApiReport extends ApiAbstract {

	/**
	 * Get all of the reports for the account.
	 *
	 * @return ResourceReport[] The list of found reports.
	 */
	public function getAll() {
		$data = $this->curl('reports')->getContent();


		// Convert
		$reports = [];
		foreach ($data['reports'] as $report) {
			$reports[] = new ResourceReport($report);
		}

		return $reports;
	}


	/**
	 * Get a report by its unique campaign ID.
	 *
	 * @param string $campaignId The unique ID of the campaign.
	 *
	 * @return ResourceReport The found report, or null if not found.
	 */
	public function get($id) {

		$report = $this->curl(['reports', $id])->getContent();

		return new ResourceReport($report);;
	}

}