<?php namespace Intellex\MailChimp;

use Intellex\MailChimp\Api\ApiCampaign;
use Intellex\MailChimp\Api\ApiLists;
use Intellex\MailChimp\Api\ApiReport;
use Intellex\MailChimp\Api\ApiSubscribers;
use Intellex\MailChimp\Api\ApiTemplates;

class Client {

	/** @var Config The configuration for the Mail Chimp client. */
	public $config;

	/**
	 * Helper constructor.
	 *
	 * @param Config $config The configuration for the Mail Chimp client.
	 */
	public function __construct(Config $config) {
		$this->config = $config;
	}

	/**
	 * Get the handler for all member (subscriber) API operations.
	 *
	 * @return ApiSubscribers The handler for all member (subscriber) API operations.
	 */
	public function subscribers() {
		return new ApiSubscribers($this);
	}

	/**
	 * Get the handler for all subscriber lists API operations.
	 *
	 * @return ApiLists The handler for all subscriber lists API operations.
	 */
	public function lists() {
		return new ApiLists($this);
	}

	/**
	 * Get the handler for all subscriber lists API operations.
	 *
	 * @return ApiTemplates The handler for all subscriber lists API operations.
	 */
	public function templates() {
		return new ApiTemplates($this);
	}

	/**
	 * Get the handler for all campaign API operations.
	 *
	 * @return ApiCampaign The handler for all campaigns.
	 */
	public function campaign() {
		return new ApiCampaign($this);
	}


	/**
	 * Get the handler for all campaign reports API operations.
	 *
	 * @return ApiReport The handler for all reports.
	 */
	public function report() {
		return new ApiReport($this);
	}

}