<?php namespace Intellex\MailChimp\Exception;

use Intellex\Curly\Response;

class ExceptionFactory {

	/**
	 * Create an error based on the response from the MailChimp API.
	 *
	 * @param Response $response       The response from the MailChimp API.
	 * @param string   $defaultMessage The message to show if the type of the exception cannot be defined from the supplied response.
	 *
	 * @return \Exception The exception matching the supplied response..
	 */
	public static function fromResponse(Response $response, $defaultMessage = 'API error') {
		$content = $response->getContent();

		// Get the type of the error
		if (key_exists('type', $content)) {
			switch ($content['type']) {

				// Validation errors
				case 'http://developer.mailchimp.com/documentation/mailchimp/guides/error-glossary/':
					return new ValidationException($content);
			}

		}

		return new \Exception($defaultMessage);
	}

}