<?php namespace Intellex\MailChimp\Exception;

use Throwable;

class ValidationException extends \Exception {

	/** @var string The URL to the defintion of this error. */
	private $type;

	/** @var string The title of the error. */
	private $title;

	/** @var int The HTTP response code. */
	private $status;

	/** @var string The human readable error message. */
	private $detail;

	/** @var string The instance ID of the request. */
	private $instance;

	/** @var array The list of validation errors. */
	private $errors;

	/**
	 * ValidationException constructor.
	 *
	 * @param array $response The error response from the MailChimp.
	 */
	public function __construct($response) {

		// Load
		$this->type = $response['type'];
		$this->title = $response['title'];
		$this->status = (int) $response['status'];
		$this->detail = $response['detail'];
		$this->instance = $response['instance'];
		$this->errors = key_exists('errors', $response) ? $response['errors'] : [];

		parent::__construct($this->detail, $this->status);
	}

	/** @var string The URL to the defintion of this error. */
	public function getType() {
		return $this->type;
	}

	/** @var string The title of the error. */
	public function getTitle() {
		return $this->title;
	}

	/** @var int The HTTP response code. */
	public function getStatus() {
		return $this->status;
	}

	/** @var string The human readable error message. */
	public function getDetail() {
		return $this->detail;
	}

	/** @var string The instance ID of the request. */
	public function getInstance() {
		return $this->instance;
	}

	/** @var array The list of validation errors. */
	public function getErrors() {
		return $this->errors;
	}

}