<?php namespace Intellex\MailChimp\Resource;

use MongoDB\BSON\UTCDateTime;

class ResourceCampaign {

	/** @var string Unique ID of the Campaign. */
	public $id;

	/** @var string title for the Campaign. */
	public $title;

	/** @var string The status of the Campaign. */
	public $status;

	/** @var string The url to Campaign archieve. */
	public $archiveUrl;

	/** @var string The number of sent emails */
	public $emailsSent;

	/** @var string The total number of emails to send */
	public $recipientCount;

	/** @var UTCDateTime Time to send the Campaign. */
	public $sendTime;

	/** @var string Unique ID of the List to send. */
	public $listId;

	/** @var string Name of the List to send. */
	public $listName;

	/** @var string Subject line for the Campaign. */
	public $subject;

	/** @var string From Name for the Campaign. */
	public $fromName;

	/** @var string From Email (reply to) for the Campaign. */
	public $reply_to;

	/** @var string Unique Id of the template used for the Campaign. */
	public $templateId;

	/** @var string Count all opened emails from the Campaign. */
	public $opens;

	/** @var string Count all clicks within html email from the Campaign. */
	public $htmlClicks;

	/** @var string Count all clicks within text email from the Campaign. */
	public $textClicks;

	/**
	 * ListResource constructor.
	 *
	 * @param object $data The data to convert to List.
	 */
	function __construct($data) {
		$this->id = $data['id'];
		$this->title = @$data['settings']['title'];
		$this->status = @$data['status'];
		$this->archiveUrl = @$data['archive_url'];
		$this->emailsSent = @$data['emails_sent'];
		$this->recipientCount = @$data['recipients']['recipient_count'];
		$this->sendTime = @$data['send_time'];
		$this->listId = @$data['recipients']['list_id'];
		$this->listName = @$data['recipients']['list_name'];
		$this->subject = @$data['settings']['subject_line'];
		$this->fromName = @$data['settings']['from_name'];
		$this->reply_to = @$data['settings']['reply_to'];
		$this->templateId = @$data['settings']['template_id'];
		$this->opens = @$data['tracking']['opens'];
		$this->htmlClicks = @$data['tracking']['html_clicks'];
		$this->textClicks = @$data['tracking']['text_clicks'];
	}

	/** @return string Unique ID of the Campaign. */
	public function getId() {
		return $this->id;
	}

	/** @return string The title of the Campaign. */
	public function getTitle() {
		return $this->title;
	}

	/**
	 * @return string
	 */
	public function getStatus() {
		return $this->status;
	}

}