<?php namespace Intellex\MailChimp\Resource;

class ResourceSubscriber {

	/** @var string Unique ID of the member. */
	public $id;

	/** @var string The email of the member. */
	public $email;

	/** @var string The subscription status. */
	public $status;

	/** @var string[] The additional merge fields. */
	public $fields;

	/**
	 * ListResource constructor.
	 *
	 * @param object $data The data to convert to List.
	 */
	function __construct($data) {
		$this->id = $data['id'];
		$this->email = $data['email_address'];
		$this->status = $data['status'];
		$this->fields = $data['merge_fields'];
	}

	/** @return string Unique ID of the member. */
	public function getId() {
		return $this->id;
	}

	/** @return string The email of the member. */
	public function getEmail() {
		return $this->email;
	}

	/** @return string The subscription status. */
	public function getStatus() {
		return $this->status;
	}

	/** @return string[] The additional merge fields. */
	public function getFields() {
		return $this->fields;
	}

}