<?php namespace Intellex\MailChimp\Resource;

class ResourceTemplate {

	/** @var string Unique ID of the Template. */
	public $id;

	/** @var string The name of the Template. */
	public $name;

	/** @var string The thumbnail of the Template. */
	public $thumbnail;

	/**
	 * ListResource constructor.
	 *
	 * @param object $data The data to convert to List.
	 */
	function __construct($data) {
		$this->id = $data['id'];
		$this->name = $data['name'];
		$this->thumbnail = $data['thumbnail'];
	}

	/** @return string Unique ID of the list. */
	public function getId() {
		return $this->id;
	}

	/** @return string The name of the list. */
	public function getName() {
		return $this->name;
	}

	/** @return string The name of the list. */
	public function getThumbnail() {
		return $this->thumbnail;
	}

}