<?php namespace Intellex\Manicure;

/**
 * Class Dimension
 * An area of the image.
 *
 * @package Intellex\Manicure
 */
class Area {

	/** @var int The X coordinate of the start of the area. */
	public $x;

	/** @var int The Y coordinate of the start of the area. */
	public $y;

	/** @var int The width of an object, in pixels. */
	public $w;

	/** @var int The height of an object, in pixels. */
	public $h;

	/**
	 * Dimension constructor.
	 *
	 * @param int $x The X coordinate of the start of the area.
	 * @param int $y The Y coordinate of the start of the area.
	 * @param int $w The width of an object, in pixels.
	 * @param int $h The height of an object, in pixels.
	 */
	public function __construct($x, $y, $w, $h) {
		$this->x = $x;
		$this->y = $y;
		$this->w = $w;
		$this->h = $h;
	}

}