<?php namespace Intellex\Manicure\Plugin;

use Intellex\Manicure\Source\ImageDataSource;
use Intellex\Manicure\Source\SourceInterface;

class Overlay implements PluginInterface {

	private $red;
	private $green;
	private $blue;
	private $alpha;

	public function __construct($red, $green, $blue, $alpha = 0) {
		$this->red = $red;
		$this->green = $green;
		$this->blue = $blue;
		$this->alpha = $alpha;
	}

	/** @inheritdoc */
	public function apply(SourceInterface $source) {

		$data = $source->getData();
		$color = imagecolorallocatealpha($data, $this->red, $this->green, $this->blue, $this->alpha);
		imagefilledrectangle($data, 0, 0, $source->getWidth(), $source->getHeight(), $color);

		return new ImageDataSource($data);
	}

}