<?php namespace Intellex\Manicure\Plugin\Resize;

use Intellex\Manicure\Source\SourceInterface;

/**
 * Class Center
 * Centers the image into a predefined box.
 *
 * @package Intellex\Manicure\Plugin
 */
class Pad extends ResizeAbstract {

	/** @inheritdoc */
	public function apply(SourceInterface $source) {
		return $this->resize($source);
	}

	/**
	 * Resize the image.
	 *
	 * @param SourceInterface $source The source on which to apply the manipulation.
	 *
	 * @return SourceInterface The reworked source.
	 */
	public function resize(SourceInterface $source) {
		$result = (new Scale($this->dimension->width, $this->dimension->height, $this->background))->apply($source);
		$result = (new Center($this->dimension->width, $this->dimension->height, $this->background))->apply($result);
		return $result;
	}
}