<?php namespace Intellex\Pixabay\Validation;

/**
 * Indicates that the validation has failed.
 */
class ValidationException extends \Exception {

	/**
	 * The name of the class which produces the validation error.
	 */
	public $className;

	/**
	 * The class member which produced the error.
	 */
	public $member;

	/**
	 * The value which produced the error.
	 */
	public $value;

	/**
	 * Human friendly validation error message.
	 */
	public $message;

	/**
	 * Initialize exception.
	 *
	 * @param string $className The name of the class which produces the validation error.
	 * @param string $member The class member which produced the error.
	 * @param string $value The value which produced the error.
	 * @param string $message Human friendly validation error message.
	 */
	public function __construct($className, $member, $value, $message) {

		# Optional additional information abou the value
		if(class_exists('\Intellex\Debugger')) {
			$value = Debugger::getReadableValue($value);
		}

		parent::__construct("Value of {$className}::{$member} cannot have a value of `{$value}`: {$message}.");
	}

	/**
	 * @return string The name of the class which produces the validation error.
	 */
	public function getClassName() {
		return $this->className;
	}

	/**
	 * @return string The class member which produced the error.
	 */
	public function getMember() {
		return $this->member;
	}

	/**
	 * @return string The value which produced the error.
	 */
	public function value() {
		return $this->value;
	}

	/**
	 * @return string Human friendly validation error message.
	 */
	public function getValidationError() {
		return $this->message;
	}

}
